//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "exporter.h"
#include "3dsftk.h"

//---------------------------------------------------------------------------
bool Export3DS::PrintError(void)
{
if (ftkerr3ds)
   {
	const ErrRec3ds *pErr = ReturnErrorList3ds ();
	char sErr[1024];
   sprintf(sErr, "ERROR (%d): %s", pErr->id, pErr->desc);
   ShowMessage(sErr);
	}
return (bool) ftkerr3ds;
}


//---------------------------------------------------------------------------
bool Export3DS::BeginExport(char * filename)
{
ClearErrList3ds();

file = OpenFile3ds ((LPCTSTR) filename, "w");
if (PrintError ()) return false;

db = NULL;
InitDatabase3ds (&db);
if (PrintError ()) return false;

CreateNewDatabase3ds (db, MeshFile);
if (PrintError ())return false;

meshset3ds *mset = NULL;
InitMeshSet3ds (&mset);
if (PrintError ()) return false;

mset->ambientlight.r = mset->ambientlight.g = mset->ambientlight.b = 0.3F;
PutMeshSet3ds (db, mset);
if (PrintError ())return false;

ReleaseMeshSet3ds (&mset);
if (PrintError ()) return false;

mesh_counter = 0;
return true;
}


//---------------------------------------------------------------------------
void Export3DS::EndExport(void)
{

WriteDatabase3ds (file, db);
if (PrintError ())return;

ReleaseDatabase3ds (&db);
if (PrintError ())return;

CloseAllFiles3ds ();
if (PrintError ())return;
}


//---------------------------------------------------------------------------
mesh3ds * Export3DS::BeginMesh(int VertexCount, int FaceCount)
{
mobj = NULL;
InitMeshObj3ds (&mobj, VertexCount, FaceCount, InitVertexArray3ds | InitTextArray3ds | InitFaceArray3ds | InitSmoothArray3ds);
if (PrintError ())return NULL;
char szOut[128] = "Mesh";
strcat(szOut, IntToStr(mesh_counter).c_str());
strcpy (mobj->name, szOut);
vertex_counter = 0;
face_counter = 0;
mesh_counter++;
return mobj;
}

void Export3DS::EndMesh(mesh3ds * mobj)
{
mobj->locmatrix[0] = 1.0F;
mobj->locmatrix[1] = 0.0F;
mobj->locmatrix[2] = 0.0F;
mobj->locmatrix[3] = 0.0F;
mobj->locmatrix[4] = 1.0F;
mobj->locmatrix[5] = 0.0F;
mobj->locmatrix[6] = 0.0F;
mobj->locmatrix[7] = 0.0F;
mobj->locmatrix[8] = 1.0F;
mobj->locmatrix[9] = 0.0F;
mobj->locmatrix[10] = 0.0F;
mobj->locmatrix[11] = 0.0F;

if (mobj->nmats > 0)
    {
    InitMeshObjField3ds (mobj, InitMatArray3ds);
	if (PrintError ()) return;

	InitMatArrayIndex3ds (mobj, 0, mobj->nfaces);
	if (PrintError ()) return;

	strcpy(mobj->matarray[0].name, mobj->name);

	for (int k = 0; k < mobj->nfaces; k++)
		{
		mobj->matarray[0].faceindex[k] = k;
		}
	mobj->matarray[0].nfaces = mobj->nfaces;
    }

PutMesh3ds (db, mobj);
if (PrintError ())return;

RelMeshObj3ds (&mobj);
if (PrintError ())return ;
}

//---------------------------------------------------------------------------
void Export3DS::AddVertex(mesh3ds * mobj,  float x, float y, float z, float u, float v)
{
mobj->vertexarray[vertex_counter].x = x;
mobj->vertexarray[vertex_counter].y = y;
mobj->vertexarray[vertex_counter].z = z;

mobj->textarray[vertex_counter].u = u;
//mobj->textarray[j].v = 1.0f - v;
mobj->textarray[vertex_counter].v = v;
vertex_counter++;
}


void Export3DS::AddFace(mesh3ds * mobj, int v1, int v2, int v3)
{
mobj->facearray[face_counter].v1 = v1;
mobj->facearray[face_counter].v2 = v2;
mobj->facearray[face_counter].v3 = v3;
mobj->facearray[face_counter].flag = FaceABVisable3ds | FaceBCVisable3ds | FaceCAVisable3ds;
mobj->smootharray[face_counter] = 1;
face_counter++;
}


void Export3DS::SetMaterial(mesh3ds * mobj, char * tex_file)
{
material3ds *mat = NULL;
InitMaterial3ds (&mat);
if (PrintError ()) return;

strcpy (mat->name, mobj->name);

for (int i=0; i < strlen(tex_file); i++)
    {
    if (tex_file[i] == '/') tex_file[i] = '\\';
    }

strcpy (mat->texture.map.name, ExtractFileName(tex_file).c_str());

mat->ambient.r = 0;
mat->ambient.g = 0;
mat->ambient.b = 0;

mat->diffuse.r = 1;
mat->diffuse.g = 1;
mat->diffuse.b = 1;

mat->specular.r = 0;
mat->specular.g = 0;
mat->specular.b = 0;

mat->shininess = 0;
mat->shinstrength = 0;

mat->wiresize = 1.0F;
mat->shading = Phong;
mat->soften = True3ds;

mat->texture.map.percent = 1.0F;
mat->texture.map.tiling = Tile;
mat->texture.map.ignorealpha = False3ds;
mat->texture.map.filter = Pyramidal;
mat->texture.map.blur = 0.0F;
mat->texture.map.mirror = False3ds;
mat->texture.map.negative = False3ds;
mat->texture.map.uscale = 1.0F;
mat->texture.map.vscale = 1.0F;
mat->texture.map.uoffset = 0.0F;
mat->texture.map.voffset = 0.0F;
mat->texture.map.rotation = 0.0F;
mat->texture.map.source = RGB;

mobj->nmats = 1;

PutMaterial3ds (db, mat);
if (PrintError ()) return;

ReleaseMaterial3ds (&mat);
if (PrintError ()) return;

}
#pragma package(smart_init)
